; Variable definitions required by Microchip floating point library
;
; Note that the absolute locations used may be changed, but these variables should be allocated
; a contiguous block of data memory, and the relative order should stay the same.
;
;       general register variables
;

SIGN            equ     0x49    ; save location for sign in MSB
TEMPB1          equ     0x4A
TEMP            equ     0x4B    ; temporary storage

;	exception flags and option bits

FPFLAGS         equ     0x42    ; floating point library exception flags

;
;       binary operation arguments
;

AARGB4          equ     0x43
AARGB3          equ     0x44
AARGB2          equ     0x45
AARGB1          equ     0x46
AARGB0          equ     0x47
AEXP            equ     0x48    ; 8 bit biased exponent for argument A
EXP             equ     0x48    ; 8 bit biased exponent - same location as AEXP

BARGB2          equ     0x4C
BARGB1          equ     0x4D
BARGB0          equ     0x4E
BEXP            equ     0x4F    ; 8 bit biased exponent for argument B

